<?Lassoscript
// Last modified: 1/15/07 by ECL, Landmann InterActive
// Prepared for Lasso Summit 07

// FUNCTIONALITY
// This file is included in the Issue page to process action_params

// Copying Action_Params to vars
// If required is missing, output an error
// If multiple errors, they will step on each other, but not worried about it

If: (Action_Param:'Error') != '';
	Var:'vError' = (Action_Param:'Error');
/If;
If: (Action_Param:'Option') != '';
	Var:'vOption' = (Action_Param:'Option');
/If;

// Pass a param "New" through the URL to indicate it is a new page
Var:'vNew' = (Action_Param:'New');

Var:'vBug_ID'=(Action_Param:'BugID');
Var:'vTitle'=(Action_Param:'Title');
	$vTitle->trim;
Var:'vDescription'=(Action_Param:'Description');
	$vDescription->trim;
Var:'vProject_ID'=(Action_Param:'Project_ID');
Var:'vVersion_ID'=(Action_Param:'Version_ID');
Var:'vSeverity_ID'=(Action_Param:'Severity_ID');
Var:'vURL'=(Action_Param:'URL');
	$vURL->trim;
	$vURL->trim;
Var:'vPriority_ID'=(Action_Param:'Priority_ID');
Var:'vStatus_ID'=(Action_Param:'Status_ID');
Var:'vResolution_ID'=(Action_Param:'Resolution_ID');
Var:'vAssigned_To'=(Action_Param:'Assigned_To');
Var:'vOS_ID'=(Action_Param:'OS_ID');
Var:'vBrowser_ID'=(Action_Param:'Browser_ID');
Var:'vClosedInVers_ID'=(Action_Param:'ClosedInVers_ID');
Var:'vToBeClosedVers_ID'=(Action_Param:'ToBeClosedVers_ID');

Var:'vCreated_By'=(Action_Param:'Created_By');
// If no Created_By, set it to current user
If: Var:'vCreated_By' == '';
	Var:'vCreated_By'=(Var:'svUser_ID');
/If;

// Used for Changelog
Var:'FormArray' = array;
Var:'FormArrayClean' = array;
Var:'DBArray' = array;
// Copy action_params to FormArray, which we will then loop through and clean of all the Lasso operators
Var:'FormArray' = (Action_Params);

	// If required is missing, output error 1003 "Required Missing"
	// but ONLY if the page has been submit
If: $vNew != 'Y';
	// Bug_ID not known on an add page, so we don't check for it
	If: (Response_Filepath) >> 'bugs_add';
		If: ($vTitle == '') || ($vDescription == '') || 
			($vURL == '') || ($vSeverity_ID == '') || ($vPriority_ID == '') || 
			($vStatus_ID == '') ||
			($vProject_ID == '') || ($vVersion_ID == '') ||   
			($vOS_ID == '') || ($vBrowser_ID == '');
			Var:'vError' = '1003';
			Var:'vOption' = 'a required field (line 67)';
		/If;
	Else;
		// Do not check for missing fields on upload, they are irrelevant
		If: $vAction != 'Upload';
			If: ($vBug_ID == '') || ($vTitle == '') || ($vDescription == '') || 
				($vURL == '') || ($vSeverity_ID == '') || ($vPriority_ID == '') || 
				($vStatus_ID == '') ||
				($vProject_ID == '') || ($vVersion_ID == '') ||   
				($vOS_ID == '') || ($vBrowser_ID == '');
				Var:'vError' = '1003';
				Var:'vOption' = 'a required field (line 76)';
			/If;
		/If;
	/If;
/If;
?>